library(RCy3)
library(STRINGdb)
library(tidyverse)
library(forcats)
#list of cytoscape apps to install
installation_responses <- c()

#list of app to install
cyto_app_toinstall <- c("clustermaker2", "enrichmentmap", "autoannotate", "wordcloud", "stringapp", "aMatReader","genemania")

cytoscape_version <- unlist(strsplit( cytoscapeVersionInfo()['cytoscapeVersion'],split = "\\."))
if(length(cytoscape_version) == 3 && as.numeric(cytoscape_version[1]>=3) 
   && as.numeric(cytoscape_version[2]>=7)){
  for(i in 1:length(cyto_app_toinstall)){
    #check to see if the app is installed.  Only install it if it hasn't been installed
    if(!grep(commandsGET(paste("apps status app=\"", cyto_app_toinstall[i],"\"", sep="")), 
             pattern = "status: Installed")){
      installation_response <-commandsGET(paste("apps install app=\"", 
                                                cyto_app_toinstall[i],"\"", sep=""))
      installation_responses <- c(installation_responses,installation_response)
    } else{
      installation_responses <- c(installation_responses,"already installed")
    }
  }
  installation_summary <- data.frame(name = cyto_app_toinstall, 
                                     status = installation_responses)
  
  knitr::kable(list(installation_summary),
               booktabs = TRUE, caption = 'A Summary of automated app installation'
  )
}

GBA_data <- read.csv("")
top_genes <- GBA_data[which(GBA_data$FDR < 0.05 & GBA_data$logFC > 2),]
head(top_genes)
mesen_string_interaction_cmd <- paste('string protein query taxonID=9606 limit=150 cutoff=0.9 query="',paste(top_genes$Genes, collapse=","),'"',sep="")
commandsGET(mesen_string_interaction_cmd)

if(file.exists(initial_string_network_png_file_name)){
  #cytoscape hangs waiting for user response if file already exists.  Remove it first
  response <- file.remove(initial_string_network_png_file_name)
} 

response <- exportImage(initial_string_network, type = "png")

#plot the results
data %>%
  mutate(name = fct_reorder(name, desc(Tissue_xd_score))) %>%
  ggplot( aes(x=name, y=Tissue_xd_score)) +
  geom_bar(stat="identity", fill="RED", alpha=.6, width=.4) +
  coord_flip() +
  xlab("") +
  theme_bw()








